﻿(function () {
    newERP.controller('ModalChequeController', ['$scope', 'ValidarFormularioService', '$timeout', 'FuncaoService', '$rootScope', 'ConsultaCnpjService', '$uibModal', '$uibModalInstance', '$localStorage', 'param', function ($scope, ValidarFormularioService, $timeout, FuncaoService, $rootScope, ConsultaCnpjService, $uibModal, $uibModalInstance, $localStorage, param) {
        var tipoEmissorCheque = {
            OMesmo: '1',
            Terceiro: '2'
        }

        $scope.informarContaCorrente = false;

        $scope.dadosCheque = {
            emissorCheque: tipoEmissorCheque.OMesmo,
            cliente: null,
            chq_observacao: null,
            contaCorrenteMovimentar: null,
            emissor: {
                chq_nomeemissor: '',
                chq_cpfcnpjemissor: '',
                chq_rgieemissor: '',
                chq_telefoneemissor: '',
                chq_emissorclientedesde: ''
            }
        };

        var cheque = {
            ban_id: '',
            chq_agencia: '',
            chq_numero: '',
            chq_dataemissao: new Date(),
            chq_valor: '',
            chq_codigocompensacao: '',
            chq_c1: '',
            chq_c2: '',
            chq_c3: '',
            chq_serie: '',
            chq_contacorrente: '',
            pes_id: '',
            chq_nomeemissor: '',
            chq_cpfcnpjemissor: '',
            chq_rgieemissor: '',
            chq_telefoneemissor: '',
            chq_emissorclientedesde: '',
            chq_observacao: '',
            chq_bompara: '',
            chq_cmc7: ''
        }

        $scope.listaValidacaoFormulario = [{ nome: 'pes_id', obrigatorio: 'Cliente Obrigatório', invalido: '' }];
        $scope.listaCheques = [];

        $scope.carregarEstruturaLancamentoCheques = function () {
            $scope.informarContaCorrente = param.dados.informarContaCorrente;
            var clienteId = param.dados.cli_id;
            $scope.listarContaCorrente();
            if (!!clienteId) {
                $scope.dadosCheque.cliente = JSON.parse(clienteAppService.buscarClientePorId(clienteId));
                $scope.carregaDadosClienteCheque($scope.dadosCheque.cliente);
            }

            var valorCheque = param.dados.valorTotal;
            var quantidadeChequesLancar = param.dados.quantidadeCheques;
            valorCheque = valorCheque / quantidadeChequesLancar;
            if (valorCheque > 0) cheque.chq_valor = parseFloat(valorCheque.toString());

            cheque.chq_bompara = new Date();
            cheque.linha1 = FuncaoService.retornaValorPorExtenso(cheque.chq_valor);

            for (var i = 1; i <= quantidadeChequesLancar; i++) {
                $scope.listaCheques.push(angular.copy(cheque));
            }

            if ($scope.informarContaCorrente === true) $scope.listaValidacaoFormulario.push({ nome: 'ctc_id', obrigatorio: 'A Conta Corrente é Obrigatória para registrar a movimentação', invalido: '', invalido: '' });
            angular.forEach($scope.listaCheques, function (objeto, indice) {
                $scope.listaValidacaoFormulario.push({ nome: 'chq_codigocompensacao_' + indice, obrigatorio: 'Comp Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'ban_id_' + indice, obrigatorio: 'Código do Banco Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_agencia_' + indice, obrigatorio: 'Número da Agência Obrigatória (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_c1_' + indice, obrigatorio: 'C1 Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_contacorrente_' + indice, obrigatorio: 'Número da Conta Obrigatória (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_c2_' + indice, obrigatorio: 'C2 Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_numero_' + indice, obrigatorio: 'Número do cheque Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_c3_' + indice, obrigatorio: 'C3 Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_valor_' + indice, obrigatorio: 'Valor Obrigatório (Cheque ' + (indice + 1) + ')', invalido: '' });
                $scope.listaValidacaoFormulario.push({ nome: 'chq_dataemissao_' + indice, obrigatorio: 'Data do Vencimento Obrigatória (Cheque ' + (indice + 1) + ')', invalido: '' });
            });
            $scope.listaValidacaoFormulario.push({ nome: 'telefoneemissor', obrigatorio: 'Telefone do Emissor é Obrigatório', invalido: '' });
            $scope.listaValidacaoFormulario.push({ nome: 'rgieemissor', obrigatorio: 'RG do Emissor é Obrigatório', invalido: '' });
            $scope.listaValidacaoFormulario.push({ nome: 'nomeemissor', obrigatorio: 'Nome do Emissor é Obrigatória', invalido: '' });
            $scope.listaValidacaoFormulario.push({ nome: 'cpfcnpjemissor', obrigatorio: 'CPF/CNPJ do Emissor é Obrigatório', invalido: '' });
        }

        $scope.completarValorPorExtenso = function (indiceChequeValor) {
            $scope.listaCheques[indiceChequeValor].linha1 = FuncaoService.retornaValorPorExtenso($scope.listaCheques[indiceChequeValor].chq_valor);
        };

        $scope.validarFormulario = function (formulario, dadosCheque) {

            $scope.listaFormularioInvalido = [];
            ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
                $scope.listaFormularioInvalido = retorno.lista;
                $scope.mensagemFormularioInvalido = retorno.mensagem;

                if ($scope.listaFormularioInvalido.length === 0) {
                    var chequesOK = true;
                    angular.forEach($scope.listaCheques, function (objeto, indice) {
                        if (chequeAppService.verificaBanco($scope.listaCheques[indice].ban_id)) {
                            $scope.listaCheques[indice].chq_cpfcnpjemissor = $scope.dadosCheque.emissor.chq_cpfcnpjemissor;
                            $scope.listaCheques[indice].chq_emissorclientedesde = $scope.dadosCheque.emissor.chq_emissorclientedesde;
                            $scope.listaCheques[indice].chq_nomeemissor = $scope.dadosCheque.emissor.chq_nomeemissor;
                            $scope.listaCheques[indice].chq_rgieemissor = $scope.dadosCheque.emissor.chq_rgieemissor;
                            $scope.listaCheques[indice].chq_observacao = $scope.dadosCheque.chq_observacao;
                            $scope.listaCheques[indice].pes_id = (!!dadosCheque.cliente.pes_id) ? dadosCheque.cliente.pes_id : null;
                            $scope.listaCheques[indice].cli_id = (!!dadosCheque.cliente.cli_id) ? dadosCheque.cliente.cli_id : null;
                            $scope.listaCheques[indice].ClienteId = (!!dadosCheque.cliente.Id) ? dadosCheque.cliente.Id : null;
                            $scope.listaCheques[indice].chq_datavencimento = (!!dadosCheque.chq_bompara) ? dadosCheque.chq_bompara : null;
                        }
                        else {
                            chequesOK = false;
                            swal("O Banco informado é INVÁLIDO!", "Cheque: " + (indice + 1).toString(), "warning");
                        }
                    });

                    var valorTotalCheques = 0;
                    angular.forEach($scope.listaCheques, function (objeto, indice) {
                        valorTotalCheques += objeto.chq_valor;
                    })
                    if (valorTotalCheques < param.dados.valorTotal) {
                        chequesOK = false;
                        if ($scope.listaCheques.length == 1) {
                            swal("Verifique o valor do cheque", "O valor informado no cheque (R$ " + FuncaoService.retornaMoney(valorTotalCheques) + ") é inferior ao informado como pagamento (R$ " + FuncaoService.retornaMoney(param.dados.valorTotal) + ")", "warning");
                        } else {
                            swal("Verifique o valor dos cheques", "Os valores informados nos cheques (R$ " + FuncaoService.retornaMoney(valorTotalCheques) + ") é inferior ao informado como pagamento (R$ " + FuncaoService.retornaMoney(param.dados.valorTotal) + ")", "warning");
                        }
                    } else if (valorTotalCheques > param.dados.valorTotal) {
                        chequesOK = false;
                        if ($scope.listaCheques.length == 1) {
                            swal("Verifique o valor do cheque", "O valor informado no cheque (R$ " + FuncaoService.retornaMoney(valorTotalCheques) + ") é superior ao informado como pagamento (R$ " + FuncaoService.retornaMoney(param.dados.valorTotal) + ")", "warning");
                        } else {
                            swal("Verifique o valor dos cheques", "Os valores informados nos cheques (R$ " + FuncaoService.retornaMoney(valorTotalCheques) + ") é superior ao informado como pagamento (R$ " + FuncaoService.retornaMoney(param.dados.valorTotal) + ")", "warning");
                        }
                    }

                    if (chequesOK == true) $uibModalInstance.close($scope.listaCheques);
                }
            });

        };

        $scope.retornaNomeBanco = function (indiceCheque) {
            var retornoBanco = bancoAppService.buscarPorId($scope.listaCheques[indiceCheque].ban_id);
            if (retornoBanco != null) {
                if (!!retornoBanco) $scope.listaCheques[indiceCheque].ban_descricao = retornoBanco.ban_descricao;
                else $scope.listacheques[indicecheque].ban_descricao = 'banco desconhecido';
            }
            else {
                swal("O Banco informado é INVÁLIDO!", "", "warning");
                $scope.listaCheques[indiceCheque].ban_id = '';
                $scope.listaCheques[indiceCheque].ban_descricao = '';
            }
        }

        $scope.buscaDadosEmissorCheque = function (cpfCnpj) {
            if (cpfCnpj.length === 11) {
                var retornoCliente = JSON.parse(clienteAppService.buscaDadosCliente(cpfCnpj));
                if (retornoCliente != null) {
                    $scope.dadosCheque.emissor.chq_nomeemissor = retornoCliente.pes_nome;
                    $scope.dadosCheque.emissor.chq_rgieemissor = retornoCliente.pef_rg;
                    if (retornoCliente.telefones.length > 0) $scope.dadosCheque.emissor.chq_telefoneemissor = retornoCliente.telefones[0].psc_numero;
                }
                else {
                    buscaDadosPessoa(cpfCnpj);
                }
            }
            else if (cpfCnpj.length === 14) {
                var retornoReceitaWS = JSON.parse(ConsultaCnpjService.consultaCnpj(cpfCnpj))
                if (retornoReceitaWS != null) {
                    $scope.dadosCheque.emissor.chq_nomeemissor = retornoReceitaWS.data.nome;
                    $scope.dadosCheque.emissor.chq_telefoneemissor = retornoReceitaWS.data.telefone;
                }
                else {
                    buscaDadosPessoa(cpfCnpj);
                }
            }
        }

        function buscaDadosPessoa(cpfCnpj) {
            var dadosPessoa = clienteAppService.buscarClienteApi(cpfCnpj);//JSON.parse(clienteAppService.buscarClienteApi(cpfCnpj));
            if (!!dadosPessoa) {
                $scope.dadosCheque.emissor.chq_nomeemissor = dadosPessoa.pes_nome;
                $scope.dadosCheque.emissor.chq_telefoneemissor = dadosPessoa.psc_numero;
                $scope.dadosCheque.emissor.chq_rgieemissor = (cpfCnpj.length == 11 ? dadosPessoa.pef_rg : dadosPessoa.pej_inscricaoestadual);
            }
        }

        $scope.carregaDadosClienteCheque = function (dadosCliente) {
            if ($scope.dadosCheque.emissorCheque == tipoEmissorCheque.OMesmo) {
                $scope.dadosCheque.emissor.chq_nomeemissor = dadosCliente.pes_nome;
                $scope.dadosCheque.emissor.ClienteId = dadosCliente.Id;
                $scope.dadosCheque.emissor.chq_cpfcnpjemissor = (dadosCliente.pes_fisicajuridica === 2 ? dadosCliente.pej_cnpj : dadosCliente.pef_cpf);
                $scope.dadosCheque.emissor.chq_rgieemissor = (dadosCliente.pes_fisicajuridica === 2 ? dadosCliente.pej_inscricaoestadual : dadosCliente.pef_rg);
                $scope.setarFocus('chq_codigocompensacao_0');
            }
        }

        $scope.defineEmissorCheque = function () {

            if ($scope.dadosCheque.emissorCheque == tipoEmissorCheque.OMesmo) {
                $scope.carregaDadosClienteCheque($scope.dadosCheque.cliente);
            }
            else {
                $scope.dadosCheque.emissor = {}
            }
        }

        $scope.leituraEfetuada = function (dadosLeituraCheque, indiceCheque) {
            if (dadosLeituraCheque.length === 34 && FuncaoService.validarCMC7(FuncaoService.retornaSoNumeros(dadosLeituraCheque))) {
                var CMC7 = FuncaoService.retornaSoNumeros(dadosLeituraCheque);
                $scope.listaCheques[indiceCheque].ban_id = CMC7.substring(0, 3);
                $scope.listaCheques[indiceCheque].chq_agencia = CMC7.substring(3, 7);
                $scope.listaCheques[indiceCheque].chq_codigocompensacao = CMC7.substring(8, 11);
                $scope.listaCheques[indiceCheque].chq_numero = CMC7.substring(11, 17);
                $scope.listaCheques[indiceCheque].chq_contacorrente = CMC7.substring(19, 29);
                if ($scope.listaCheques[indiceCheque].chq_contacorrente.substring(0, 4) == '0000') $scope.listaCheques[indiceCheque].chq_contacorrente = $scope.listaCheques[indiceCheque].chq_contacorrente.substr(4, 6);
                $scope.listaCheques[indiceCheque].chq_cmc7 = CMC7.substr(0, 8) + ' ' + CMC7.substr(8, 11) + ' ' + CMC7.substr(19, 11);
                $scope.retornaNomeBanco(indiceCheque);
                $scope.setarFocus('chq_c1_' + indiceCheque);
            }
            else {
                swal("O número lido no documento não parece um número válido para cheques (CMC7)", "", "warning");
            }
        }

        $scope.setarFocus = function (nomeElemento) {
            if (!!nomeElemento) $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });
        };

        $scope.closeModalCheque = function () {
            $scope.cancelandoOperacao = true;
            swal({
                title: "Deseja realmente cancelar o lançamento de cheque?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não, continuar lançamento",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "SIM, cancelar a operação",
                closeOnConfirm: true
            },
                function (acao) {
                    if (acao) {
                        $uibModalInstance.close();
                    }
                    else {
                        $scope.cancelandoOperacao = false;
                        $scope.$digest();
                    }
                });
        }

        $scope.listarContaCorrente = function () {
            $scope.listaContaCorrente = [];
            $scope.listaContaCorrente = JSON.parse(contaCorrenteAppService.listarContaCorrente());
        };

    }]);
})();