﻿(function () {
    newERP.controller('ModalAnaliseCreditoController', ['$scope', '$location', 'growlService', 'ValidarFormularioService', '$state', '$localStorage', '$filter', '$timeout', '$window', 'DadosFormularioService', '$rootScope', 'ModalService', 'FuncaoService', '$q', 'StepsService', function ($scope, $location, growlService, ValidarFormularioService, $state, $localStorage, $filter, $timeout, $window, DadosFormularioService, $rootScope, ModalService, FuncaoService, $q, StepsService) {
        var enums = {
            casado: 2,
            respostaPredefinida: 2,
            soma: 1,
            subtrai: 2
        }

        $scope.iniciarDados = function () {
            if (!!$scope.dadosCliente.ecv_id) {
                $scope.dadosCliente.ecv_id = $scope.dadosCliente.ecv_id.ecv_id;
            };

            $scope.listarEstadoCivil();
            if (!!$scope.dadosCliente.ecv_id) {
                $scope.dadosCliente.ecv_id = [{ ecv_id: (!!$scope.dadosCliente.ecv_id) ? $scope.dadosCliente.ecv_id : $scope.dadosCliente.ecv_id }][0];

                $scope.verificarEstadoCivil($scope.dadosCliente.ecv_id);
            } else {
                $scope.dadosCliente.ecv_id = null;
            };
            $scope.listarPerguntas();
        };

        $scope.listarPerguntas = function () {
            $scope.steps = [];
            $scope.model.listaQuestaoLimiteCredito = {};
            var retorno = JSON.parse(questaoLimiteCreditoAppService.listarTodas());
            var contador = 1;
            for (var i = 0; i < retorno.length; i++) {
                retorno[i].step = contador;
                var dado = {
                    step: contador,
                    name: retorno[i].qlc_questao,
                    qlc_id: retorno[i].qlc_id,
                    qlc_tiporesposta: retorno[i].qlc_tiporesposta,
                    respostasLimiteCredito: retorno[i].RespostasLimiteCredito
                }
                $scope.steps.push(dado);
                contador++;
            }
        };

        $scope.questionario = [];
        var dadosQuestionario = {};
        $scope.adicionarResposta = function (pergunta, resposta, porcentagem) {
            for (var i = 0; i < $scope.questionario.length; i++) {
                if ($scope.questionario[i].pergunta.qlc_id === pergunta.qlc_id) {
                    $scope.questionario.splice(i, 1);
                }
            }
            dadosQuestionario = { pergunta: pergunta, resposta: resposta, porcentagem: porcentagem * 100 }
            $scope.questionario.push(dadosQuestionario);
        };

        $scope.listarEstadoCivil = function () {
            $scope.model.listaEstadoCivil = [];
            var retorno = JSON.parse(estadoCivilAppService.listarTodos());
            $scope.model.listaEstadoCivil = retorno;
        };

        $scope.verificarEstadoCivil = function (dados) {
            if (dados.ecv_descricao === "Casado(a)" || dados.ecv_id === enums.casado) {
                $scope.isCasado = true;
            } else {
                $scope.dadosCliente.pef_rendaconjuge = 0;
                $scope.isCasado = false;
            };
        };

        $scope.gerarLimite = function (dadosAnalise) {
            var dados = {
                pef_renda: $scope.dadosCliente.pef_renda,
                pef_rendaconjuge: $scope.dadosCliente.pef_rendaconjuge,
                questionario: $scope.questionario,
            }
            var retorno = JSON.parse(analiseCreditoAppService.gerarLimiteCredito(JSON.stringify(dados)));
            $scope.dadosCliente.cli_valorlimitecredito = retorno;
            swal("Limite Calculado!", "", "success");
            $scope.modalAnaliseCredito.close();
        };

        $scope.valorSimulado = 0;
        $scope.simular = function (dadosAnalise) {
            $timeout(function () {
                var porcentagem = 0.0;
                var porcentagemBase = 0.3; // 30%
                var retornoPercentual = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
                if (retornoPercentual.par_percentuallimitecredito != null) {
                    porcentagemBase = retornoPercentual.par_percentuallimitecredito / 100;
                }
                if (!!$scope.questionario) {
                    for (var i = 0; i < $scope.questionario.length; i++) {
                        if ($scope.questionario[i].pergunta.qlc_tiporesposta == enums.respostaPredefinida) {
                            if ($scope.questionario[i].resposta.rlc_somasubtrai == enums.soma) {
                                porcentagem += ($scope.questionario[i].resposta.rlc_percentual / 100);
                            } else {
                                porcentagem -= ($scope.questionario[i].resposta.rlc_percentual / 100);
                            }
                        }
                    }

                    /* MUDADO PROCESSO - BUG 994  */
                    if (!!$scope.dadosCliente.pef_rendaconjuge) {
                        var valorBase = ($scope.dadosCliente.pef_renda + $scope.dadosCliente.pef_rendaconjuge) * porcentagemBase
                        $scope.valorSimulado = valorBase * porcentagem;
                        $scope.valorSimulado = (porcentagem !== 0) ? valorBase + (valorBase * porcentagem) : valorBase;
                    } else {
                        var valorBase = $scope.dadosCliente.pef_renda * porcentagemBase;
                        $scope.valorSimulado = (porcentagem !== 0) ? valorBase + (valorBase * porcentagem) : valorBase;
                    }
                    /* MUDADO PROCESSO - BUG 994  */
                }
            });
        }

        $scope.finalizar = function () {
            $scope.gerarLimite($scope.dadosCliente);
            alert($scope.questionario);
        };

        $scope.irPara = function (to) {
            StepsService.steps().goTo(to);
        };
    }]);
})()