﻿newERP.controller('EstornoParcelaController', ['$scope', '$filter', '$timeout', 'DadosFormularioService', '$state', 'ModalService', 'FuncaoService', function ($scope, $filter, $timeout, DadosFormularioService, $state, ModalService, FuncaoService) {

    var dataAtual = new Date();
    $scope.filtro = {
        dataInicial: new Date(dataAtual.getFullYear(), dataAtual.getMonth(), dataAtual.getDate()),
        dataFinal: new Date(dataAtual.getFullYear(), dataAtual.getMonth() + 1, 0),
        pessoa: null
    };

    $scope.ListaParcelas = [];
    $scope.BuscarParcelas = function (pessoa) {
        $scope.ListaParcelas = JSON.parse(parcelaAppService.listarParcelasQuitadasNewerp(pessoa.Id, $scope.filtro.dataInicial, $scope.filtro.dataFinal));
        console.log('RetornoParcelas: ', $scope.ListaParcelas);
    };

    $scope.estornarRecebimentoParcela = function (parcela) {
        swal({
            title: "ATENÇÃO!!",
            text: "Deseja Estornar o Recebimento da Parcela?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-success",
            confirmButtonText: "Sim",
            closeOnConfirm: false
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    var retorno = permissaoGerencialAppService.solicitarPermissaoGerencial();
                    if (retorno == true) {
                        var retorno = parcelaAppService.estornarRecebimentoParcela(parcela);
                        if (retorno) {
                            swal("ATENÇÃO!", "Recebimento Estornado com Sucesso!", "success");
                            $timeout(function () {
                                $scope.BuscarParcelas($scope.filtro.pessoa, $scope.filtro.dataInicial, $scope.filtro.dataFinal);
                            });
                        } else {
                            swal("ATENÇÃO!", "Erro ao Estornar Recebimento!", "error");
                        }
                    }
                }, 100);
            }
        })
    };

    $scope.imprimirComprovante = function (dadosParcela) {
        parcelaAppService.reImprimirComprovantePagamento(dadosParcela);
    };
        

}]);