﻿newERP.controller('ClienteController', ['$scope', 'ModalService', 'GeneroService', 'ValidarFormularioService', '$timeout', '$state', 'DadosFormularioService', 'ConsultaCnpjService', 'FuncaoService', '$filter', '$parse', '$q', 'RelatorioService', '$localStorage', 'growlService', function ($scope, ModalService, GeneroService, ValidarFormularioService, $timeout, $state, DadosFormularioService, ConsultaCnpjService, FuncaoService, $filter, $parse, $q, RelatorioService, $localStorage, growlService) {

    $scope.dadosCliente = {
        endereco: {},
        telefone: {}
    };

    var enumPessoaFisicaJuridica = {
        pessoaFisica: 1,
        pessoaJuridica: 2,
        pessoaEstrangeiro: 3
    };

    $scope.desabilitaCPFCNPJ = false;
    $scope.isEndereco = false;
    $scope.isTelefone = false;
    $scope.isPessoaAutorizada = false;
    $scope.bloquearCampoCidade = true;
    $scope.bloquearCampoUF = true;

    var alterarEndereco = false;
    var alterarEnderecoPosicao = null;
    var alterarTelefone = false;
    var alterarTelefonePosicao = null;

    $scope.model = {
        ListaRegimeTributarioFiscal: [],
        ListaEndereco: [],
        ListaTelefone: [],
        ListaPessoaAutorizada: [],
        ListaPais: [],
        ListaEstadoCivil: [],
        ListaTipoTelefone: [],
        ListaTipoEndereco: [],
        ListaGrauParentesco: [],
        ListaEstadoRG: [],
        pagina: 1
    };

    $scope.filtro = {
        pesquisa: ''
    };

    $scope.contatosCliente = {
        telefones: [],
        emails: null,
        enderecos: []
    };

    $scope.abaContatos = [
        {
            titulo: 'Telefones',
            pagina: 'views/pdv/varejo/cliente/listarTelefone.html'
        },
        {
            titulo: 'E-mails',
            pagina: 'views/pdv/varejo/cliente/listarEmail.html'
        },
        {
            titulo: 'Endereços',
            pagina: 'views/pdv/varejo/cliente/listarEnderecos.html'
        }
    ];

    $scope.ListaClientes = [];
    $scope.listarClientesScroll = function () {
        $scope.model.pagina++;
        var listaClientes = JSON.parse(clienteAppService.consultarClientes($scope.model.pagina, $scope.filtro.pesquisa));
        angular.forEach(listaClientes, function (cliente) {
            cliente.descricaoVerificarLimiteCredito = "Verificar Limite";
            cliente.limiteCreditoDisponivel = null;
            $scope.ListaClientes.push(cliente);
        });
    };

    $scope.listarClientes = function () {
        $scope.model.pagina = 1;
        $scope.ListaClientes = [];
        var listaClientes = JSON.parse(clienteAppService.consultarClientes($scope.model.pagina, $scope.filtro.pesquisa, 30));
        angular.forEach(listaClientes, function (cliente) {
            cliente.descricaoVerificarLimiteCredito = "Verificar Limite";
            cliente.limiteCreditoDisponivel = null;
            $scope.ListaClientes.push(cliente);
        });
    };
    $scope.lerDados = function () {
        clienteAppService.buscarNovosClientesApi();
    };

    $scope.alteraStatusPrincipalTelefone = function (posicao) {
        for (var i = 0; i < $scope.model.ListaTelefone.length; i++) {
            $scope.model.ListaTelefone[i].psc_principal = false;
        }
        $scope.model.ListaTelefone[posicao].psc_principal = true;
    };

    $scope.alteraStatusPrincipalEndereco = function (posicao) {
        for (var i = 0; i < $scope.model.ListaEndereco.length; i++) {
            $scope.model.ListaEndereco[i].pee_enderecoprincipal = false;
        }
        $scope.model.ListaEndereco[posicao].pee_enderecoprincipal = true;
    };

    $scope.retornaDescricaoTipoEndereco = function (tpeId) {
        let tipoEndereco = $scope.model.ListaTipoEndereco.filter(tpe => tpe.tpe_id === tpeId)[0];
        return (!!tipoEndereco === true ? tipoEndereco.tpe_descricao : null);
    };

    $scope.iniciarDadosManutencao = function () {
        $timeout(function () {
            $scope.model.ListaRegimeTributarioFiscal = JSON.parse(enumAppService.listaEnum("RegimeTributarioFiscal"))
            $scope.model.ListaTipoEndereco = JSON.parse(tipoEnderecoAppService.listarTodos());
            $scope.model.ListaTipoTelefone = JSON.parse(tipoTelefoneAppService.listarTodos());
            $scope.model.ListaGrauParentesco = JSON.parse(grauParentescoAppService.listarTodos());
            $scope.model.ListaPais = JSON.parse(paisAppService.listarTodos());
            $scope.model.ListaEstadoRG = JSON.parse(estadoAppService.listarTodos(33));

            $scope.dadosCliente = DadosFormularioService.retornaDados('cliente-manutencao', { voltarParaVenda: false }).dados;

            if (!!$scope.dadosCliente.pes_idestrangeiro === true) {
                $scope.dadosCliente.descricaoEstrangeiro = '(Caso for cliente brasileiro clique aqui)';
                $scope.dadosCliente.descricaoCampo = 'Informe o documento ';
                $scope.dadosCliente.apresentaEstrangeiro = true;
            } else {
                $scope.dadosCliente.descricaoEstrangeiro = '(Caso for cliente estrangeiro clique aqui)';
                $scope.dadosCliente.descricaoCampo = 'Informe o CPF/CNPJ ';
                $scope.dadosCliente.apresentaEstrangeiro = false;
            }

            buscarCamposAdicionaisCliente();
            if (!!$scope.dadosCliente.Id) {
                $scope.carregaDadosCliente($scope.dadosCliente.Id);
            }

            if (!!$scope.dadosCliente.pes_cpfcnpj) {
                $scope.verificarCPFCNPJValido($scope.dadosCliente.pes_cpfcnpj);
            }

        }, 50);
    };

    $scope.abrirManutencaoCliente = function (dadosCliente) {
        if (dadosCliente !== null) {
            DadosFormularioService.armazenarDados('cliente-manutencao', dadosCliente);
        }
        $state.go("newpdv.manutencao-cliente");
    };

    $scope.verificaGenero = function (nomeCliente, cpfCnpj) {
        if (!!cpfCnpj == true) {
            if (cpfCnpj.length == 11) {
                if (!!nomeCliente == true) {
                    var cliente = nomeCliente.split(' ')[0];
                    var retorno = GeneroService.Definir(cliente);
                    if (retorno == 0) {
                        $scope.dadosCliente.pef_sexo = 'F';
                    }
                    else {
                        $scope.dadosCliente.pef_sexo = 'M';
                    }
                }
            }
        } else {
            if (!!nomeCliente == true) {
                var cliente = nomeCliente.split(' ')[0];
                var retorno = GeneroService.Definir(cliente);
                if (retorno == 0) {
                    $scope.dadosCliente.pef_sexo = 'F';
                }
                else {
                    $scope.dadosCliente.pef_sexo = 'M';
                };
            }
        }
    };

    var tipoCampoAdicional = {
        Texto: 1,
        Numero: 2,
        ValorMonetario: 3,
        Data: 4,
        Marcador: 5,
        Selecionar: 6
    };

    var buscarCamposAdicionaisCliente = function () {
        if (!!$scope.dadosCliente.Id) {
            var dadosClienteCampoAdicional = JSON.parse(clienteCampoAdicionalAppService.listar($scope.dadosCliente.Id));

            var retornoCampoAdicionalCliente = JSON.parse(campoAdicionalClienteAppService.listar());
            var camposAdicionaisNaoOrdenados = [];
            $scope.camposAdicionais = [];
            angular.forEach(retornoCampoAdicionalCliente, function (campo) {
                var nomeAjustado = FuncaoService.retornaSoLetras(FuncaoService.removerAcentos(campo.cac_nome));

                camposAdicionaisNaoOrdenados.push({
                    cac_id: campo.cac_id,
                    cal_id: campo.identidade,
                    col: campo.coluna,
                    row: campo.linha,
                    sizeX: campo.tamanho,
                    sizeY: 0,
                    html: campo.html,
                    htmlCampo: '<div class="col-sm-' + campo.tamanho + '">' + campo.html + '</div>',

                    nome: campo.cac_nome,
                    nomeAjustado: nomeAjustado,
                    descricao: campo.cac_descricao,
                    titulo: campo.cac_titulo,

                    tipoCampo: campo.cac_tipocampo,
                    opcoesSelect: JSON.parse(campo.cac_opcoesselect),
                    obrigatorio: campo.campoobrigatorio,
                    placeholder: campo.cac_placeholder,
                    maxlength: campo.cac_numeromaximocaracteres,
                    casasDecimais: campo.cac_numerocasasdecimais,
                    valorPadrao: campo.cac_valorpadrao
                });

                if (!!campo.campoobrigatorio) {
                    $scope.listaValidacaoFormulario.push({ nome: nomeAjustado, obrigatorio: campo.cac_nome + ' é Obrigatório', invalido: '' });
                }

                var valorInformado = null;
                var possuiValorInformado = $filter('filter')(dadosClienteCampoAdicional, { 'cac_id': campo.cac_id });
                if (!!possuiValorInformado.length) {
                    valorInformado = possuiValorInformado[0].cca_valor;
                }

                switch (campo.cac_tipocampo) {
                    case tipoCampoAdicional.Marcador:
                        if (!!valorInformado) {
                            if ((valorInformado).toString().toUpperCase() == "TRUE") {
                                valorInformado = true;
                            } else {
                                valorInformado = false;
                            }
                        }
                        $parse('campoAdicional.' + nomeAjustado).assign($scope, (!!valorInformado) ? (!!valorInformado) : (!!campo.cac_valorpadrao));
                        break;
                    case tipoCampoAdicional.Numero:
                    case tipoCampoAdicional.ValorMonetario:
                        if (!!valorInformado) {
                            while (valorInformado.indexOf(',') != -1) {
                                valorInformado = valorInformado.replace(',', '.');
                            }
                        }
                        $parse('campoAdicional.' + nomeAjustado).assign($scope, (!!valorInformado) ? parseFloat(valorInformado) : null);
                        break;
                    default:
                        $parse('campoAdicional.' + nomeAjustado).assign($scope, (!!valorInformado) ? valorInformado : null);
                        break;
                }
            });
            $scope.camposAdicionais = $filter('orderBy')(camposAdicionaisNaoOrdenados, ['row', 'col']);

            $scope.dadosCliente.camposAdicionais = $scope.campoAdicional;
        } else {
            var retornoCampoAdicionalCliente = JSON.parse(campoAdicionalClienteAppService.listar());
            var camposAdicionaisNaoOrdenados = [];
            $scope.camposAdicionais = [];
            angular.forEach(retornoCampoAdicionalCliente, function (campo) {
                var nomeAjustado = FuncaoService.retornaSoLetras(FuncaoService.removerAcentos(campo.cac_nome));

                camposAdicionaisNaoOrdenados.push({
                    cac_id: campo.cac_id,
                    cal_id: campo.identidade,
                    col: campo.coluna,
                    row: campo.linha,
                    sizeX: campo.tamanho,
                    sizeY: 0,
                    html: campo.html,
                    htmlCampo: '<div class="col-sm-' + campo.tamanho + '">' + campo.html + '</div>',

                    nome: campo.cac_nome,
                    nomeAjustado: nomeAjustado,
                    descricao: campo.cac_descricao,
                    titulo: campo.cac_titulo,

                    tipoCampo: campo.cac_tipocampo,
                    opcoesSelect: JSON.parse(campo.cac_opcoesselect),
                    obrigatorio: campo.campoobrigatorio,
                    placeholder: campo.cac_placeholder,
                    maxlength: campo.cac_numeromaximocaracteres,
                    casasDecimais: campo.cac_numerocasasdecimais,
                    valorPadrao: campo.cac_valorpadrao
                });

                if (!!campo.campoobrigatorio) {
                    $scope.listaValidacaoFormulario.push({ nome: nomeAjustado, obrigatorio: campo.cac_nome + ' é Obrigatório', invalido: '' });
                }

                if (campo.cac_tipocampo == tipoCampoAdicional.Marcador) {
                    $parse('campoAdicional.' + nomeAjustado).assign($scope, (!!campo.cac_valorpadrao));
                } else {
                    $parse('campoAdicional.' + nomeAjustado).assign($scope, null);
                }
            });
            $scope.camposAdicionais = $filter('orderBy')(camposAdicionaisNaoOrdenados, ['row', 'col']);

            $scope.dadosCliente.camposAdicionais = $scope.campoAdicional;
        }
    };

    $scope.alteraInformacaoCpfcnpjEstrangeiro = function (valor) {
        if (valor === true) {
            $scope.dadosCliente.descricaoEstrangeiro = '(Caso for cliente estrangeiro clique aqui)';
            $scope.dadosCliente.descricaoCampo = 'Informe o CPF/CNPJ ';
            $scope.dadosCliente.apresentaEstrangeiro = false;
            $scope.dadosCliente.pes_idestrangeiro = null;
        } else {
            $scope.dadosCliente.descricaoEstrangeiro = '(Caso for cliente brasileiro clique aqui)';
            $scope.dadosCliente.descricaoCampo = 'Informe o documento ';
            $scope.dadosCliente.apresentaEstrangeiro = true;
            $scope.dadosCliente.pes_cpfcnpj = null;
        }
    };

    $scope.limparFormularioCliente = function () {
        $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaFisica;
        $scope.dadosCliente.pes_nome = "";
        $scope.dadosCliente.pej_cnpj = "";
        $scope.dadosCliente.pef_cpf = "";
        $scope.dadosCliente.pej_nomefantasia = "";
        $scope.dadosCliente.pej_datafundacao = null;
        $scope.dadosCliente.pej_inscricaoestadual = "";
        $scope.dadosCliente.pej_pessoacontato = "";
        $scope.dadosCliente.pej_emailpessoacontato = "";
        $scope.dadosCliente.pef_sexo = null;
        $scope.dadosCliente.pef_datanascimento = null;
        $scope.dadosCliente.pef_apelido = "";
        $scope.dadosCliente.pef_rg = "";
        $scope.dadosCliente.pef_rguf = "";
        $scope.dadosCliente.pef_rgorgaoexpedidor = "";
        $scope.dadosCliente.pef_rgdataexpedicao = null;
        $scope.dadosCliente.pef_nomepai = "";
        $scope.dadosCliente.pef_nomemae = "";
        $scope.dadosCliente.pef_produtorrural = false;
        $scope.dadosCliente.cli_regimetributariofiscal = 0;
        $scope.dadosCliente.cli_valorlimitecredito = 0;
        $scope.dadosCliente.cli_datainiciallimitecred = null;
        $scope.dadosCliente.cli_datafinallimitecred = null;
        $scope.dadosCliente.cli_naoprotestar = false;
        $scope.dadosCliente.cli_vendasomenteavista = false;
        $scope.dadosCliente.cli_observacao = "";
        $scope.dadosCliente.endereco = (!!$scope.dadosCliente.endereco) ? $scope.dadosCliente.endereco : {};
        $scope.dadosCliente.endereco.pee_cep = "";
        $scope.dadosCliente.endereco.pee_cidade = "";
        $scope.dadosCliente.endereco.pee_bairro = "";
        $scope.dadosCliente.endereco.pee_endereco = "";
        $scope.dadosCliente.endereco.pee_numero = "";
        $scope.dadosCliente.endereco.pee_uf = "";
        $scope.dadosCliente.endereco.pee_complemento = "";
        $scope.dadosCliente.endereco.pee_referencia = "";
        $scope.dadosCliente.telefone = (!!$scope.dadosCliente.telefone) ? $scope.dadosCliente.telefone : {};
        $scope.dadosCliente.telefone.psc_numero = "";
        $scope.dadosCliente.telefone.psc_principal = false;
        $scope.dadosCliente.telefone.psc_ramal = "";
        $scope.dadosCliente.telefone.psc_observacao = "";
        $scope.model.ListaEndereco = [];
        $scope.model.ListaTelefone = [];
        $scope.model.ListaPessoaAutorizada = [];
    };

    $scope.verificaFisicaJuridica = function (cpfcnpj) {
        $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaFisica;
        if (!!cpfcnpj !== false) {
            if (cpfcnpj.length === 11) {
                if (FuncaoService.validarCPF(cpfcnpj) === false) {
                    swal('CPF INVÁLIDO!', 'O CPF informado é inválido. Verique se você digitou o número correto do documento.', 'error');
                    return false;
                }
                var retorno = JSON.parse(clienteAppService.verificarCpfExistente(cpfcnpj));
                if (!!retorno) {
                    $scope.limparFormularioCliente();
                    if (!!retorno.pes_id && !!retorno.pef_cpf) {
                        swal({
                            title: "Já existe o CPF " + retorno.pef_cpf + " cadastrado no sistema!",
                            text: "Cliente: " + retorno.pes_nome,
                            type: "warning",
                            showCancelButton: true,
                            cancelButtonText: "OK",
                            confirmButtonClass: "btn-success",
                            confirmButtonText: "Atualizar dados",
                            closeOnConfirm: true
                        }, function (acao) {
                            if (!acao) {
                                $state.go('newpdv.consulta-cliente');
                            } else {
                                $scope.montaFormularioCliente(retorno);
                            }
                        });
                    } else {
                        $scope.montaFormularioCliente(retorno);
                    }
                } else {
                    if (!!!$scope.dadosCliente.Id) {
                        $scope.limparFormularioCliente();
                    }
                    $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaFisica;
                }
            } else if (cpfcnpj.length === 14) {
                if (FuncaoService.validarCNPJ(cpfcnpj) === false) {
                    swal('CNPJ INVÁLIDO!', 'O CNPJ informado é inválido. Verique se você digitou o número correto do documento.', 'error');
                    return false;
                }
                var retorno = JSON.parse(clienteAppService.verificarCnpjExistente(cpfcnpj));
                if (!!retorno) {
                    $scope.limparFormularioCliente();
                    if (!!retorno.cli_id && !!retorno.pej_cnpj) {
                        swal({
                            title: "Já existe o CNPJ " + retorno.pej_cnpj + " cadastrado no sistema!",
                            text: "Cliente: " + retorno.pes_nome,
                            type: "warning",
                            showCancelButton: true,
                            cancelButtonText: "OK",
                            confirmButtonClass: "btn-success",
                            confirmButtonText: "Atualizar dados",
                            closeOnConfirm: true
                        }, function (acao) {
                            if (!acao) {
                                $state.go('newpdv.consulta-cliente');
                            } else {
                                $scope.montaFormularioCliente(retorno);
                            }
                        });
                    } else {
                        $scope.montaFormularioCliente(retorno);
                    }
                } else {
                    if (!!!$scope.dadosCliente.Id) {
                        $scope.limparFormularioCliente();
                    }
                    $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaJuridica;
                }
            } else {
                $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaJuridica;
                $scope.verficaCnpjReceitaWs(cpfcnpj);
            }
        } else if (!!$scope.dadosCliente.pes_idestrangeiro) {
            $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaEstrangeiro;
        } else {
            $scope.dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaFisica;
        }
    };

    $scope.verificarCPFCNPJValido = function (cpfcnpj) {
        if (!!cpfcnpj !== false) {
            if (cpfcnpj.length === 11) {
                if (FuncaoService.validarCPF(cpfcnpj) === false) {
                    swal('CPF INVÁLIDO!', 'O CPF informado é inválido. Verique se você digitou o número correto do documento.', 'error');
                    $scope.desabilitaCPFCNPJ = false;
                }
                var retorno = JSON.parse(clienteAppService.verificarCpfExistente(cpfcnpj));
                if (!!retorno) {
                    $scope.desabilitaCPFCNPJ = true;
                } else {
                    $scope.desabilitaCPFCNPJ = false;

                }
            } else if (cpfcnpj.length === 14) {
                if (FuncaoService.validarCNPJ(cpfcnpj) === false) {
                    swal('CNPJ INVÁLIDO!', 'O CNPJ informado é inválido. Verique se você digitou o número correto do documento.', 'error');
                    $scope.desabilitaCPFCNPJ = false;

                }
                var retorno = JSON.parse(clienteAppService.verificarCnpjExistente(cpfcnpj));
                if (!!retorno) {
                    $scope.desabilitaCPFCNPJ = true;
                } else {
                    $scope.desabilitaCPFCNPJ = false;
                }
            } else {
                $scope.desabilitaCPFCNPJ = false;
            }
        } else {
            $scope.desabilitaCPFCNPJ = false;
        }
    };

    $scope.montaFormularioCliente = function (dados) {
        $timeout(function () {
            $scope.dadosCliente.cli_codigo = dados.cli_codigo;
            $scope.dadosCliente.cli_id = dados.cli_id;
            $scope.dadosCliente.pes_id = dados.pes_id;
            $scope.dadosCliente.cli_regimetributariofiscal = dados.cli_regimetributariofiscal;
            $scope.dadosCliente.pes_nome = dados.pes_nome;
            $scope.dadosCliente.pef_apelido = dados.pef_apelido;
            $scope.dadosCliente.pef_datanascimento = dados.pef_datanascimento;
            $scope.dadosCliente.pef_nomemae = dados.pef_nomemae;
            $scope.dadosCliente.pef_nomepai = dados.pef_nomepai;
            $scope.dadosCliente.pef_produtorrural = dados.pef_produtorrural;
            $scope.dadosCliente.pef_rg = dados.pef_rg;
            $scope.dadosCliente.pef_rgdataexpedicao = dados.pef_rgdataexpedicao;
            $scope.dadosCliente.pef_rgorgaoexpedidor = dados.pef_rgorgaoexpedidor;
            $scope.dadosCliente.pef_rguf = dados.pef_rguf;
            $scope.dadosCliente.pef_sexo = dados.pef_sexo;
            $scope.dadosCliente.pej_datafundacao = dados.pej_datafundacao;
            $scope.dadosCliente.pej_emailpessoacontato = dados.pej_emailpessoacontato;
            $scope.dadosCliente.pej_inscricaoestadual = dados.pej_inscricaoestadual;
            $scope.dadosCliente.pej_inscricaomunicipal = dados.pej_inscricaomunicipal;
            $scope.dadosCliente.pej_nomefantasia = dados.pej_nomefantasia;
            $scope.dadosCliente.pej_pessoacontato = dados.pej_pessoacontato;
            $scope.dadosCliente.pes_fisicajuridica = dados.pes_fisicajuridica;
            $scope.dadosCliente.pes_idestrangeiro = dados.pes_idestrangeiro;
            $scope.dadosCliente.psc_numero = dados.psc_numero;
            $scope.dadosCliente.psc_principal = dados.psc_principal;
            $scope.model.ListaEndereco = JSON.parse(clienteEnderecoAppService.buscar(dados.Id));
            $scope.model.ListaTelefone = JSON.parse(clienteTelefoneAppService.buscar(dados.Id));
        });
    };

    $scope.adicionarEndereco = function (dadosEndereco) {
        if ($scope.model.ListaEndereco.length === 0) {
            dadosEndereco.pee_enderecoprincipal = true;
        } else if (!alterarEndereco) {
            var listEndereco = $scope.model.ListaEndereco.filter(e => e.pee_enderecoprincipal === true)
            if (listEndereco.length === 1) {
                dadosEndereco.pee_enderecoprincipal = false;
            } else {
                dadosEndereco.pee_enderecoprincipal = true;
            }
        }
        dadosEndereco.pse_id = dadosEndereco.pais.pse_id;
        dadosEndereco.tpe_id = dadosEndereco.tpe_id.tpe_id;
        if (alterarEndereco) {
            $scope.model.ListaEndereco[alterarEnderecoPosicao] = dadosEndereco;
        } else {
            $scope.model.ListaEndereco.push(dadosEndereco);
        }

        alterarEndereco = false;
        $scope.dadosCliente.endereco = {};
        $scope.closeEndereco();
    };

    $scope.editarEndereco = function (dadosEndereco, posicao) {
        $scope.dadosCliente.endereco = dadosEndereco;
        if (!!$scope.dadosCliente.endereco.pse_id) {
            $scope.dadosCliente.endereco.pais = [{
                pse_id: (!!$scope.dadosCliente.endereco.pse_id) ? $scope.dadosCliente.endereco.pse_id : $scope.dadosCliente.endereco
            }][0];
        }

        if (!!$scope.dadosCliente.endereco.tpe_id) {
            var temp = $scope.dadosCliente.endereco.tpe_id;
            delete $scope.dadosCliente.endereco.tpe_id;
            $scope.dadosCliente.endereco.tpe_id = {};
            $scope.dadosCliente.endereco.tpe_id.tpe_id = temp;
        };

        $scope.bloquearCampoCidade = true;
        $scope.bloquearCampoUF = true;
        alterarEndereco = true;
        alterarEnderecoPosicao = posicao;
        $scope.isEndereco = true;
    };

    $scope.removerEndereco = function (posicao) {
        swal({
            title: "Remover o Endereço Selecionado ?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    $scope.model.ListaEndereco.splice(posicao, 1);
                }, 100);
            };
        });
    };

    $scope.adicionarTelefone = function (dadosTelefone) {
        if ($scope.model.ListaTelefone.length === 0) {
            dadosTelefone.psc_principal = true;
        } else if (!alterarTelefone) {
            var listTel = $scope.model.ListaTelefone.filter(t => t.psc_principal === true)
            if (listTel.length === 1) {
                dadosTelefone.psc_principal = false;
            } else {
                dadosTelefone.psc_principal = true;
            }
        }
        dadosTelefone.tpt_id = dadosTelefone.tpt_id.tpt_id;
        if (alterarTelefone) {
            $scope.model.ListaTelefone.splice(alterarTelefonePosicao, 1, dadosTelefone);
            if (!!dadosTelefone.psc_principal === true) $scope.alteraStatusPrincipalTelefone(alterarTelefonePosicao);
        } else {
            $scope.model.ListaTelefone.push(dadosTelefone);
            if (!!dadosTelefone.psc_principal === true) $scope.alteraStatusPrincipalTelefone($scope.model.ListaTelefone.length - 1);
        }
        alterarTelefone = false;
        $scope.dadosCliente.telefone = {};
        $scope.closeTelefone();
    };

    $scope.editarTelefone = function (dadosTelefone, posicao) {
        $scope.dadosCliente.telefone = dadosTelefone;

        if (!!$scope.dadosCliente.telefone.tpt_id) {
            $scope.dadosCliente.telefone.tpt_id = [{ tpt_id: (!!$scope.dadosCliente.telefone.tpt_id) ? $scope.dadosCliente.telefone.tpt_id : $scope.dadosCliente.telefone.tpt_id.tpt_id }][0];
        }
        alterarTelefone = true;
        alterarTelefonePosicao = posicao;
        $scope.isTelefone = true;
    };

    $scope.removerTelefone = function (posicao) {
        swal({
            title: "Remover o Telefone Selecionado ?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    $scope.model.ListaTelefone.splice(posicao, 1);
                }, 100);
            }
        });
    };

    $scope.salvarCliente = function (dadosCliente) {
        dadosCliente.camposAdicionais = JSON.stringify($scope.campoAdicional);
        dadosCliente.endereco = $scope.model.ListaEndereco;
        dadosCliente.telefone = $scope.model.ListaTelefone;
        dadosCliente.pessoaAutorizada = $scope.model.ListaPessoaAutorizada;
        dadosCliente.cli_regimetributariofiscal = !!$scope.dadosCliente.cli_regimetributariofiscal ? $scope.dadosCliente.cli_regimetributariofiscal.Key : 0;
        dadosCliente.pef_rguf = !!dadosCliente.pef_rguf ? dadosCliente.pef_rguf.est_sigla : "";
        dadosCliente.ecv_id = null;
        dadosCliente.cli_naoprotestar = (!!dadosCliente.cli_naoprotestar) ? dadosCliente.cli_naoprotestar : false;
        dadosCliente.cli_vendasomenteavista = (!!dadosCliente.cli_vendasomenteavista) ? dadosCliente.cli_vendasomenteavista : false;
        dadosCliente.pef_produtorrural = (!!dadosCliente.pef_produtorrural) ? dadosCliente.pef_produtorrural : false;
        dadosCliente.pef_rg = (!!$scope.dadosCliente.pef_rg) ? $scope.dadosCliente.pef_rg : null;

        if (!!dadosCliente.pes_cpfcnpj) {
            if (dadosCliente.pes_cpfcnpj.length === 11) {
                dadosCliente.pef_cpf = dadosCliente.pes_cpfcnpj;
                dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaFisica;
            } else if (dadosCliente.pes_cpfcnpj.length === 14) {
                dadosCliente.pej_cnpj = dadosCliente.pes_cpfcnpj;
                dadosCliente.pes_fisicajuridica = enumPessoaFisicaJuridica.pessoaJuridica;
            }
        }

        if (!!dadosCliente.Id) {
            var retornoEdicaoCliente = clienteAppService.editar(JSON.stringify(dadosCliente));
            swal({
                title: 'Cliente Alterado com Sucesso!',
                text: "",
                type: "success",
                confirmButtonClass: "btn-info",
                confirmButtonText: "OK",
                closeOnConfirm: false
            }, function (acao) {
                if (acao) {
                    $timeout(function () {
                        if (!!$scope.dadosCliente.voltarParaVenda) {
                            var dadosVenda = DadosFormularioService.retornaDados('venda-varejo', { descontoEmValorOuPercentual: '$', acrescimoEmValorOuPercentual: '$' }).dados;
                            dadosVenda.pes_cpfcnpj = $scope.dadosCliente.pes_cpfcnpj;
                            dadosVenda.pes_nome = $scope.dadosCliente.pes_nome;
                            dadosVenda.ClienteId = $scope.dadosCliente.Id;
                            DadosFormularioService.limparDados('venda-varejo');
                            DadosFormularioService.armazenarDados('venda-varejo', dadosVenda);
                            $state.go('newpdv.venda-varejo');
                        } else {
                            localStorage.setItem('ClienteId', $scope.dadosCliente.Id);
                            $state.go('newpdv.consulta-cliente');
                        }

                        $scope.limparFormularioCliente();
                        $scope.dadosCliente.pes_cpfcnpj = "";
                        $scope.alteraInformacaoCpfcnpjEstrangeiro(true);
                        DadosFormularioService.limparDados('cliente-manutencao');
                        $scope.SolicitarImpressaoDaListaDePessoasAutorizadas();
                    }, 100);
                }
            });
        } else {
            var retornoCliente = clienteAppService.incluir(JSON.stringify(dadosCliente));
            swal({
                title: 'Cliente Adicionado com Sucesso!',
                text: "",
                type: "success",
                confirmButtonClass: "btn-info",
                confirmButtonText: "OK",
                closeOnConfirm: false
            }, function (acao) {
                if (acao) {
                    $timeout(function () {
                        if (!!$scope.dadosCliente.voltarParaVenda) {
                            var dadosVenda = DadosFormularioService.retornaDados('venda-varejo', { descontoEmValorOuPercentual: '$', acrescimoEmValorOuPercentual: '$' }).dados;
                            dadosVenda.pes_cpfcnpj = $scope.dadosCliente.pes_cpfcnpj;
                            dadosVenda.pes_nome = $scope.dadosCliente.pes_nome;
                            dadosVenda.ClienteId = retornoCliente.id;
                            DadosFormularioService.limparDados('venda-varejo');
                            DadosFormularioService.armazenarDados('venda-varejo', dadosVenda);
                            $state.go('newpdv.venda-varejo');
                        } else {
                            localStorage.setItem('ClienteId', retornoCliente.id);
                            $state.go('newpdv.consulta-cliente');
                        }

                        $scope.limparFormularioCliente();
                        $scope.dadosCliente.pes_cpfcnpj = "";
                        $scope.alteraInformacaoCpfcnpjEstrangeiro(true);
                        DadosFormularioService.limparDados('cliente-manutencao');
                        $scope.SolicitarImpressaoDaListaDePessoasAutorizadas();
                    }, 100);
                }
            });
        }
    };

    $scope.visualizarRelatorio = function (codigo) {
        if (navigator.onLine) {
            growlService.growl('Aguarde, estamos gerando a Ficha do Cliente.', 'info', null, 2500);
            var cliente = JSON.parse(clienteAppService.buscar(codigo));
            if (!!cliente.cli_id) {
                var cli_id = JSON.stringify({
                    'cli_id': cliente.cli_id
                })
                var filtros = [
                    {
                        'nome': 'cli_id',
                        'valor': JSON.parse(cli_id)
                    }
                ];
                $timeout(function () {
                    RelatorioService.exibirRelatorio('ef6b08e3-5c8f-4072-b8f2-2340e49e39cd', filtros);
                });
            }
        }
        else {
            growlService.growl('O PDV está offline, não foi possível gerar a Ficha do Cliente.', 'danger', null, 2500);
        }
    };

    $scope.SolicitarImpressaoDaListaDePessoasAutorizadas = function () {
        var ClienteId = parseInt(localStorage.getItem('ClienteId'));
        var retorno = JSON.parse(clientePessoaAutorizadaAppService.buscar(ClienteId));
        if (!navigator.onLine) {
            if (retorno.length > 0) {
                swal({
                    title: 'Atenção!',
                    text: "Você deseja Imprimir a Lista de Clientes Autorizados a Comprar em nome deste Cliente?",
                    type: "info",
                    showCancelButton: true,
                    cancelButtonText: "Não",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "Sim, quero Imprimir",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        clientePessoaAutorizadaAppService.impressaoNaoFiscalRelatorioPessoasAutorizadas(ClienteId);
                    }
                });
            } else {
                swal.close();
            };
        }
        swal.close();
    };

    $scope.listaValidacaoFormulario = [
        {
            nome: 'pes_nome', obrigatorio: 'O Nome do Cliente é Obrigatório', invalido: ''
        },
        { nome: 'pej_inscricaoestadual', obrigatorio: '', invalido: 'Inscrição Estadual é Inválida' }
    ];

    $scope.validarFormulario = function (formulario, dadosCliente) {
        $scope.listaFormularioInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
            $scope.listaFormularioInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;
            if ($scope.listaFormularioInvalido.length > 1) {
                $scope.mensagemFormularioInvalido = 'Antes de salvar verifique os erros:';
            }
            if ($scope.listaFormularioInvalido.length === 0) {
                $scope.salvarCliente(dadosCliente);
            }
        });
    };

    $scope.listaValidacaoFormularioEndereco = [
        {
            nome: 'pse_pais', obrigatorio: 'O Pais é Obrigatório', invalido: ''
        },
        {
            nome: 'endereco', obrigatorio: 'O Endereço é Obrigatório', invalido: ''
        },
        {
            nome: 'tipoendereco', obrigatorio: 'O Tipo de Endereço é Obrigatório', invalido: ''
        },
        { nome: 'pie_inscricaoestadual', obrigatorio: '', invalido: 'Inscrição Estadual é inválida!' }
    ];

    $scope.validarFormularioEndereco = function (formulario, dadosEndereco) {
        $scope.listaFormularioEnderecoInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioEndereco).then(function (retorno) {
            $scope.listaFormularioEnderecoInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;
            if ($scope.dadosCliente.apresentaEstrangeiro === false) {
                if (!!!$scope.dadosCliente.endereco.pee_cep) {
                    $scope.listaFormularioEnderecoInvalido.push({ nome: 'cep_cep', mensagem: 'O CEP é Obrigatório' });
                };

                if (!!!$scope.dadosCliente.endereco.pee_bairro) {
                    $scope.listaFormularioEnderecoInvalido.push({ nome: 'end_bairro', mensagem: 'O Bairro é Obrigatório' });
                };

                if (!!!$scope.dadosCliente.endereco.pee_cidade) {
                    $scope.listaFormularioEnderecoInvalido.push({ nome: 'cidade', mensagem: 'Cidade Inválida' });
                };

                if (!!!$scope.dadosCliente.endereco.pee_uf) {
                    $scope.listaFormularioEnderecoInvalido.push({ nome: 'uf', mensagem: 'UF Inválido' });
                };
            }

            if ($scope.listaFormularioEnderecoInvalido.length === 0) {
                $scope.adicionarEndereco(dadosEndereco);
                $scope.isEndereco = false;
            }
        });
    };

    $scope.listaValidacaoFormularioTelefone = [
        {
            nome: 'telefone', obrigatorio: 'O Telefone é Obrigatório', invalido: ''
        },
        { nome: 'tipotelefone', obrigatorio: 'O Tipo de Telefone é Obrigatório', invalido: '' }
    ];

    $scope.validarFormularioTelefone = function (formulario, dadosTelefone) {
        $scope.listaFormularioTelefoneInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioTelefone).then(function (retorno) {
            $scope.listaFormularioTelefoneInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;

            if ($scope.listaFormularioTelefoneInvalido.length === 0) { $scope.adicionarTelefone(dadosTelefone); } else {
                return;
            }
        });
    };

    $scope.setarFocus = function (nomeElemento) {
        if ((parseInt(nomeElemento))) {
            $scope.paginaAtiva = parseInt(nomeElemento);
        } else {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        };
    };

    $scope.closeTelefone = function () {
        $scope.isTelefone = false;
    };

    $scope.closeEndereco = function () {
        $scope.dadosCliente.endereco = {
        };
        $scope.isEndereco = false;
    };

    $scope.abrirEndereco = function () {
        $timeout(function () {
            $scope.model.ListaPais.reduce(function (prevVal, pais, index) {
                if (pais.pse_codigobacen == 1058) {
                    $scope.bloquearCampoCidade = true;
                    $scope.bloquearCampoUF = true;
                    $scope.dadosCliente.endereco = (!!$scope.dadosCliente.endereco) ? $scope.dadosCliente.endereco : {
                    };
                    $scope.dadosCliente.endereco.pais = [{
                        pse_codigobacen: pais.pse_codigobacen,
                        pse_codigoiso: pais.pse_codigoiso,
                        pse_formatocep: pais.pse_formatocep,
                        pse_id: pais.pse_id,
                        pse_nome: pais.pse_nome,
                        pse_sigla: pais.pse_sigla,
                        pse_siglaiso: pais.pse_siglaiso
                    }][0];
                }
            })
        }, 100)
        $scope.isEndereco = true;
    };

    $scope.abrirTelefone = function () {
        $scope.isTelefone = true;
        alterarTelefone = null;
    }

    $scope.carregaDadosCliente = function (codigoCliente) {
        $scope.dadosCliente = JSON.parse(clienteAppService.buscar(codigoCliente));
        $scope.dadosCliente.pes_cpfcnpj = (!!$scope.dadosCliente.pef_cpf) ? $scope.dadosCliente.pef_cpf : $scope.dadosCliente.pej_cnpj;
        if (!!$scope.dadosCliente.cli_regimetributariofiscal) {
            $scope.dadosCliente.cli_regimetributariofiscal = [{ Key: (!!$scope.dadosCliente.cli_regimetributariofiscal) ? $scope.dadosCliente.cli_regimetributariofiscal : $scope.dadosCliente.cli_regimetributariofiscal }][0];
        }

        if (!!$scope.dadosCliente.pef_rguf) {
            $scope.dadosCliente.pef_rguf = [{ est_sigla: (!!$scope.dadosCliente.pef_rguf) ? $scope.dadosCliente.pef_rguf : $scope.dadosCliente.pef_rguf }][0];
        } else {
            $scope.dadosCliente.pef_rguf = null;
        };

        $scope.model.ListaEndereco = JSON.parse(clienteEnderecoAppService.buscar(codigoCliente));
        $scope.model.ListaTelefone = JSON.parse(clienteTelefoneAppService.buscar(codigoCliente));

        /* Pessoa Autorizada */
        $scope.model.ListaPessoaAutorizada = JSON.parse(clientePessoaAutorizadaAppService.listarTodas(codigoCliente));
        angular.forEach($scope.model.ListaPessoaAutorizada, function (reg) {
            reg.grauParentesco = {
                grp_id: reg.grp_id,
                grp_descricao: reg.grp_descricao
            };
            if (!!reg.pea_codigodigital) {
                reg.digitalCadastrada = true;
            } else {
                reg.digitalCadastrada = false;
            }
        });
        /* Pessoa Autorizada */

        $scope.alteraInformacaoCpfcnpjEstrangeiro(true);

        buscarCamposAdicionaisCliente();
    };

    $scope.openAnaliseCredito = function () {
        $scope.modalAnaliseCredito = ModalService.model($scope, 'views/pdv/varejo/modalAnaliseCredito.html', 'lg', true, true, true);
    };

    $scope.buscarCidadeEstado = function (cep) {
        if (!!cep && cep.length === 8) {
            $scope.dadosCliente.endereco.pee_cidade = "";
            $scope.dadosCliente.endereco.pee_uf = ""
            var busca = JSON.parse(cidadeAppService.buscar(cep));
            if (!!busca) {
                if (!!busca.cid_descricao) {
                    $scope.limparFormularioEndereco();
                    $scope.dadosCliente.endereco.pee_cep = cep;
                    $scope.dadosCliente.endereco.cid_ibge = busca.cid_ibge;
                    $scope.dadosCliente.endereco.pee_cidade = busca.cid_descricao;
                    $scope.dadosCliente.endereco.pee_uf = busca.est_sigla;
                } else {
                    pesquisaCepPostmon(cep);
                }
            } else {
                pesquisaCepPostmon(cep);
            }
        }
    };

    var pesquisaCepPostmon = function (cep) {
        if (!(!!$scope.isEstrangeiro)) {
            var retornoCep = JSON.parse(cidadeAppService.buscarPostmon(cep));
            if (retornoCep != null) {
                $scope.dadosCliente.endereco.pee_cidade = retornoCep.cidade;
                $scope.dadosCliente.endereco.cid_ibge = retornoCep.cidade_info == undefined ? 0 : retornoCep.cidade_info.codigo_ibge;
                $scope.dadosCliente.endereco.pee_uf = retornoCep.estado;

                if (!!retornoCep.bairro) {
                    $scope.dadosCliente.endereco.pee_bairro = retornoCep.bairro;
                }

                if (!!retornoCep.endereco) {
                    var endereco = retornoCep.endereco.split(',');
                    $scope.dadosCliente.endereco.pee_endereco = endereco[0];
                    $scope.dadosCliente.endereco.pee_numero = (endereco[1] == undefined) ? '' : endereco[1];
                } else if (!!retornoCep.logradouro) {
                    var endereco = retornoCep.logradouro.split(',');
                    $scope.dadosCliente.endereco.pee_endereco = endereco[0];
                    $scope.dadosCliente.endereco.pee_numero = (endereco[1] == undefined) ? '' : endereco[1];
                }

                if (!!retornoCep.complemento == true) {
                    $scope.dadosCliente.endereco.pee_complemento = retornoCep.complemento;
                }
            } else {
                $scope.bloquearCampoCidade = false;
                $scope.bloquearCampoUF = false;
                //$scope.limparFormularioEndereco();
            }
        }
    };

    $scope.limparFormularioEndereco = function () {
        $scope.dadosCliente.endereco.cid_ibge = "";
        $scope.dadosCliente.endereco.pee_cep = "";
        $scope.dadosCliente.endereco.pee_cidade = "";
        $scope.dadosCliente.endereco.pee_bairro = "";
        $scope.dadosCliente.endereco.pee_endereco = "";
        $scope.dadosCliente.endereco.pee_numero = "";
        $scope.dadosCliente.endereco.pee_uf = "";
        $scope.dadosCliente.endereco.pee_complemento = "";
        $scope.dadosCliente.endereco.pee_referencia = "";
    };

    $scope.limparFormularioTelefone = function () {
        $scope.dadosCliente.telefone.psc_numero = "";
        $scope.dadosCliente.telefone.psc_principal = false;
        $scope.dadosCliente.telefone.psc_ramal = "";
        $scope.dadosCliente.telefone.psc_observacao = "";
    };

    $scope.verificaPais = function (pais) {
        if (pais.pse_codigobacen === "1058") { $scope.isEstrangeiro = false; } else {
            $scope.isEstrangeiro = true;
        }
    };

    $scope.cancelar = function () {
        $scope.exibir = !$scope.exibir;
        $scope.limparFormularioCliente();
        DadosFormularioService.limparDados('cliente-manutencao');
        $state.go('newpdv.consulta-cliente');
    };

    $scope.verficaCnpjReceitaWs = function (cpfCnpj) {
        ConsultaCnpjService.consultaCnpj(cpfCnpj).then(function (retornoReceitaWS) {
            var dados = retornoReceitaWS.data;
            if (dados.status == "OK" && dados.situacao == "ATIVA") {
                $scope.dadosCliente.pej_nomefantasia = dados.fantasia;
                $scope.dadosCliente.pes_nome = dados.nome;
                if (dados.abertura !== undefined) {
                    var dia = dados.abertura.substring(0, 2);
                    var mes = dados.abertura.substring(3, 5);
                    var ano = dados.abertura.substring(6, 10);
                }
                $scope.dadosCliente.pej_datafundacao = new Date(ano, mes, dia);
                $scope.dadosCliente.pej_emailpessoacontato = dados.email;

                $scope.model.ListaEndereco = [];
                var endereco = {
                    pee_endereco: dados.complemento,
                    pee_bairro: dados.bairro,
                    pee_cidade: dados.municipio,
                    pee_cep: FuncaoService.removerCaracteresEspeciais(dados.cep),
                    pee_uf: dados.uf,
                    tpe_id: $scope.model.ListaTipoEndereco[0].tpe_id
                }
                $scope.model.ListaEndereco.push(endereco);

                $scope.model.ListaTelefone = [];
                var telefone = {
                    psc_principal: true,
                    psc_ramal: null,
                    psc_observacao: null,
                    psc_numero: FuncaoService.removerCaracteresEspeciais(dados.telefone),
                    tpt_id: $scope.model.ListaTipoTelefone[0].tpt_id
                }
                $scope.model.ListaTelefone.push(telefone);
            }
        });
    };


    $scope.ContatosCliente = function (codigoCliente) {
        $scope.contatosCliente.telefones = JSON.parse(clienteAppService.buscaTelefoneCliente(codigoCliente, null, null));
        $scope.contatosCliente.emails = JSON.parse(clienteAppService.buscarEmailCliente(codigoCliente));
        $scope.contatosCliente.enderecos = JSON.parse(clienteAppService.buscaEnderecoCliente(codigoCliente, null));
        $scope.modalTelefone = ModalService.model($scope, 'views/pdv/varejo/cliente/modalContatoCliente.html', 'lg', true, true, true);
    };

    $scope.VerificarLimiteDeCredito = function (dadosCliente) {
        if (navigator.onLine) {
            var limiteCreditoDisponivel = JSON.parse(clienteAppService.limiteCreditoDisponivel(dadosCliente.pes_id));
            if (!!limiteCreditoDisponivel) {
                if (!!limiteCreditoDisponivel.valorTotal) {
                    dadosCliente.limiteCreditoDisponivel = limiteCreditoDisponivel.valorTotal;
                    dadosCliente.descricaoVerificarLimiteCredito = null;
                } else {
                    dadosCliente.descricaoVerificarLimiteCredito = "Limite Não Definido!";
                }
            } else {
                dadosCliente.descricaoVerificarLimiteCredito = "Limite Não Definido!";
            }
        } else {
            dadosCliente.descricaoVerificarLimiteCredito = "Sem conexao Com a API do Newerp";
        }
    };


    $scope.listaValidacaoFormularioPessoaAutorizada = [
        {
            nome: 'pea_cpf', obrigatorio: 'Informe o CPF da Pessoa Autorizada!', invalido: ''
        },
        { nome: 'pea_nome', obrigatorio: 'Informe o Nome da Pessoa Autorizada!', invalido: '' }
    ];

    $scope.validarFormularioPessoaAutorizada = function (formulario, dadosPessoaAutorizada) {
        $scope.listaFormularioInvalidoPessoaAutorizada = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioPessoaAutorizada).then(function (retorno) {
            $scope.listaFormularioInvalidoPessoaAutorizada = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;

            if (!!dadosPessoaAutorizada.grauParentesco) {
                if (!!!dadosPessoaAutorizada.grauParentesco.grp_id) {
                    $scope.listaFormularioInvalidoPessoaAutorizada.push({ nome: 'grauParentesco', mensagem: 'Informe o Grau de Parentesco!' });
                }
            }

            if ($scope.listaFormularioInvalidoPessoaAutorizada.length === 0) {
                $scope.adicionarPessoaAutorizada(dadosPessoaAutorizada);
                $scope.isPessoaAutorizada = false;
            }
        });
    };

    $scope.dadosPessoaAutorizada = {
        pef_cpf: '',
        pes_nome: '',
        pea_grau: null,
        pea_ativo: false,
        grauParentesco: [],
        pea_codigodigital: null
    };

    $scope.closePessoaAutorizada = function () {
        if ($scope.alterarPessoaAutorizada) {
            $scope.model.ListaPessoaAutorizada[$scope.dadosPessoaAutorizada.index] = $scope.dadosPessoaAutorizada.backup;
        }
        $scope.isPessoaAutorizada = false;
        $scope.dadosPessoaAutorizada = {
            pef_cpf: '',
            pes_nome: '',
            pea_grau: null,
            pea_ativo: false,
            grauParentesco: [],
            pea_codigodigital: null
        };
    };

    $scope.abrirPessoaAutorizada = function () {
        $scope.isPessoaAutorizada = true;
        $scope.alterarPessoaAutorizada = false;
    };

    $scope.adicionarPessoaAutorizada = function (dadosPessoaAutorizada) {
        if ($scope.model.ListaPessoaAutorizada.length > 0) {
            for (var i = 0; i < $scope.model.ListaPessoaAutorizada.length; i++) {
                if ($scope.model.ListaPessoaAutorizada[i].pef_cpf === dadosPessoaAutorizada.pef_cpf) {
                    $scope.model.ListaPessoaAutorizada.splice(i, 1);
                    break;
                }
            }
        }

        $scope.model.ListaPessoaAutorizada.push(dadosPessoaAutorizada);
        $scope.dadosPessoaAutorizada = {
            pef_cpf: '',
            pes_nome: '',
            pea_grau: null,
            pea_ativo: false,
            grauParentesco: [],
            pea_codigodigital: null
        };
    };

    $scope.removerPessoaAutorizada = function (posicao, pessoaAutorizada) {
        swal({
            title: "Remover Pessoa " + pessoaAutorizada.pes_nome + "?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    if (pessoaAutorizada.pea_id) {
                        $timeout(function () {
                            swal("Atenção!", "Não foi possível excluir a pessoa autorizada, deve conter referências com outros registros, o mesmo será inativado!", "warning");
                            pessoaAutorizada.pea_ativo = false;
                        }, 100);
                    } else {
                        $scope.model.ListaPessoaAutorizada.splice(posicao, 1);
                    }
                }, 100);
            }
        })
    };

    $scope.verificaCPFPessoaAutorizada = function (cpf, formulario) {
        $timeout(function () {
            if (formulario.pea_cpf.$invalid && cpf != "") {
                $scope.dadosPessoaAutorizada.pef_cpf = '';
                swal("Atenção!", "Ops! CPF Inválido!", "warning");
            }

            if ($scope.dadosCliente.pes_cpfcnpj === cpf) {
                swal("Ops! O CPF da Pessoa deve ser diferente do cliente!", "", "warning");
                $scope.dadosPessoaAutorizada.pef_cpf = '';
            } else {
                if (!!cpf !== false) {
                    if (cpf.length === 11) {
                        var retorno = JSON.parse(clienteAppService.verificarCpfExistente(cpf));
                        if (retorno) {
                            var cliente = JSON.parse(clienteAppService.buscaDadosCliente(cpf))
                            if (!!cliente) {
                                $scope.dadosPessoaAutorizada.pes_nome = cliente.pes_nome;
                            }
                        }
                    }
                }
            }
        })
    };

    $scope.alterarPessoaAutorizada = false;

    $scope.editarPessoaAutorizada = function (index, dadosPessoaAutorizada) {
        $scope.isPessoaAutorizada = true;
        $scope.alterarPessoaAutorizada = true;
        $scope.dadosPessoaAutorizada = dadosPessoaAutorizada;
        $scope.dadosPessoaAutorizada.backup = angular.copy(dadosPessoaAutorizada);
        $scope.dadosPessoaAutorizada.index = index;
    };

    $scope.cadastrarDigital = function (dadosPessoaAutorizada) {
        var retornoDigital = JSON.parse(leitorBiometricoAppService.abrirFormCadastroBiometrico());
        if (!!retornoDigital.base64) {
            $scope.dadosPessoaAutorizada.pea_codigodigital = retornoDigital.base64;
            dadosPessoaAutorizada.digitalCadastrada = true;
            swal('ATENÇÃO', "Digital Capturada com Sucesso!", "success");
        }
    };

}]);