// Generated by CoffeeScript 1.10.0

/*
PDFFont - embeds fonts in PDF documents
By Devon Govett
 */

(function() {
  var AFMFont, PDFFont, Subset, TTFFont, fs;

  TTFFont = require('./font/ttf');

  AFMFont = require('./font/afm');

  Subset = require('./font/subset');

  // fs = require('fs');

  PDFFont = (function() {
    var STANDARD_FONTS, toUnicodeCmap;

    function PDFFont(document, src, family, id) {
      this.document = document;
      this.id = id;
      if (typeof src === 'string') {
        if (src in STANDARD_FONTS) {
          this.isAFM = true;
          this.font = new AFMFont(STANDARD_FONTS[src]());
          this.registerAFM(src);
          return;
        } else if (/\.(ttf|ttc)$/i.test(src)) {
          this.font = TTFFont.open(src, family);
        } else if (/\.dfont$/i.test(src)) {
          this.font = TTFFont.fromDFont(src, family);
        } else {
          throw new Error('Not a supported font format or standard PDF font.');
        }
      } else if (Buffer.isBuffer(src)) {
        this.font = TTFFont.fromBuffer(src, family);
      } else if (src instanceof Uint8Array) {
        this.font = TTFFont.fromBuffer(new Buffer(src), family);
      } else if (src instanceof ArrayBuffer) {
        this.font = TTFFont.fromBuffer(new Buffer(new Uint8Array(src)), family);
      } else {
        throw new Error('Not a supported font format or standard PDF font.');
      }
      this.subset = new Subset(this.font);
      this.registerTTF();
    }

    STANDARD_FONTS = {
      // "Courier": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Courier.afm", 'utf8');
      // },
      // "Courier-Bold": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Courier-Bold.afm", 'utf8');
      // },
      // "Courier-Oblique": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Courier-Oblique.afm", 'utf8');
      // },
      // "Courier-BoldOblique": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Courier-BoldOblique.afm", 'utf8');
      // },
      // "Helvetica": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Helvetica.afm", 'utf8');
      // },
      // "Helvetica-Bold": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Helvetica-Bold.afm", 'utf8');
      // },
      // "Helvetica-Oblique": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Helvetica-Oblique.afm", 'utf8');
      // },
      // "Helvetica-BoldOblique": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Helvetica-BoldOblique.afm", 'utf8');
      // },
      // "Times-Roman": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Times-Roman.afm", 'utf8');
      // },
      // "Times-Bold": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Times-Bold.afm", 'utf8');
      // },
      // "Times-Italic": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Times-Italic.afm", 'utf8');
      // },
      // "Times-BoldItalic": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Times-BoldItalic.afm", 'utf8');
      // },
      // "Symbol": function() {
      //   return fs.readFileSync(__dirname + "/font/data/Symbol.afm", 'utf8');
      // },
      // "ZapfDingbats": function() {
      //   return fs.readFileSync(__dirname + "/font/data/ZapfDingbats.afm", 'utf8');
      // }
    };

    PDFFont.prototype.use = function(characters) {
      var ref;
      return (ref = this.subset) != null ? ref.use(characters) : void 0;
    };

    PDFFont.prototype.embed = function() {
      if (this.embedded || (this.dictionary == null)) {
        return;
      }
      if (this.isAFM) {
        this.embedAFM();
      } else {
        this.embedTTF();
      }
      return this.embedded = true;
    };

    PDFFont.prototype.encode = function(text) {
      var ref;
      if (this.isAFM) {
        return this.font.encodeText(text);
      } else {
        return ((ref = this.subset) != null ? ref.encodeText(text) : void 0) || text;
      }
    };

    PDFFont.prototype.ref = function() {
      return this.dictionary != null ? this.dictionary : this.dictionary = this.document.ref();
    };

    PDFFont.prototype.registerTTF = function() {
      var e, hi, low, raw, ref;
      this.name = this.font.name.postscriptName;
      this.scaleFactor = 1000.0 / this.font.head.unitsPerEm;
      this.bbox = (function() {
        var j, len, ref, results;
        ref = this.font.bbox;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          e = ref[j];
          results.push(Math.round(e * this.scaleFactor));
        }
        return results;
      }).call(this);
      this.stemV = 0;
      if (this.font.post.exists) {
        raw = this.font.post.italic_angle;
        hi = raw >> 16;
        low = raw & 0xFF;
        if (hi & 0x8000 !== 0) {
          hi = -((hi ^ 0xFFFF) + 1);
        }
        this.italicAngle = +(hi + "." + low);
      } else {
        this.italicAngle = 0;
      }
      this.ascender = Math.round(this.font.ascender * this.scaleFactor);
      this.decender = Math.round(this.font.decender * this.scaleFactor);
      this.lineGap = Math.round(this.font.lineGap * this.scaleFactor);
      this.capHeight = (this.font.os2.exists && this.font.os2.capHeight) || this.ascender;
      this.xHeight = (this.font.os2.exists && this.font.os2.xHeight) || 0;
      this.familyClass = (this.font.os2.exists && this.font.os2.familyClass || 0) >> 8;
      this.isSerif = (ref = this.familyClass) === 1 || ref === 2 || ref === 3 || ref === 4 || ref === 5 || ref === 7;
      this.isScript = this.familyClass === 10;
      this.flags = 0;
      if (this.font.post.isFixedPitch) {
        this.flags |= 1 << 0;
      }
      if (this.isSerif) {
        this.flags |= 1 << 1;
      }
      if (this.isScript) {
        this.flags |= 1 << 3;
      }
      if (this.italicAngle !== 0) {
        this.flags |= 1 << 6;
      }
      this.flags |= 1 << 5;
      if (!this.font.cmap.unicode) {
        throw new Error('No unicode cmap for font');
      }
    };

    PDFFont.prototype.embedTTF = function() {
      var charWidths, cmap, code, data, descriptor, firstChar, fontfile, glyph;
      data = this.subset.encode();
      fontfile = this.document.ref();
      fontfile.write(data);
      fontfile.data.Length1 = fontfile.uncompressedLength;
      fontfile.end();
      descriptor = this.document.ref({
        Type: 'FontDescriptor',
        FontName: this.subset.postscriptName,
        FontFile2: fontfile,
        FontBBox: this.bbox,
        Flags: this.flags,
        StemV: this.stemV,
        ItalicAngle: this.italicAngle,
        Ascent: this.ascender,
        Descent: this.decender,
        CapHeight: this.capHeight,
        XHeight: this.xHeight
      });
      descriptor.end();
      firstChar = +Object.keys(this.subset.cmap)[0];
      charWidths = (function() {
        var ref, results;
        ref = this.subset.cmap;
        results = [];
        for (code in ref) {
          glyph = ref[code];
          results.push(Math.round(this.font.widthOfGlyph(glyph)));
        }
        return results;
      }).call(this);
      cmap = this.document.ref();
      cmap.end(toUnicodeCmap(this.subset.subset));
      this.dictionary.data = {
        Type: 'Font',
        BaseFont: this.subset.postscriptName,
        Subtype: 'TrueType',
        FontDescriptor: descriptor,
        FirstChar: firstChar,
        LastChar: firstChar + charWidths.length - 1,
        Widths: charWidths,
        Encoding: 'MacRomanEncoding',
        ToUnicode: cmap
      };
      return this.dictionary.end();
    };

    PDFFont.prototype.getEmbedInfoTTF = function() {
      var data = this.subset.encode();
      var charWidths = (function() {
        var ref, results;
        ref = this.subset.cmap;
        results = [];
        for (code in ref) {
          glyph = ref[code];
          results.push(Math.round(this.font.widthOfGlyph(glyph)));
        }
        return results;
      }).call(this);
      var firstChar = +Object.keys(this.subset.cmap)[0];
      return {
        fontfile: data,
        descriptor: {
          Type: 'FontDescriptor',
          FontName: this.subset.postscriptName,
          FontBBox: this.bbox,
          Flags: this.flags,
          StemV: this.stemV,
          ItalicAngle: this.italicAngle,
          Ascent: this.ascender,
          Descent: this.decender,
          CapHeight: this.capHeight,
          XHeight: this.xHeight
        },
        firstChar: firstChar,
        charWidths: charWidths,
        cmap: toUnicodeCmap(this.subset.subset),
        dictionary: {
          Type: 'Font',
          BaseFont: this.subset.postscriptName,
          Subtype: 'TrueType',
          FirstChar: firstChar,
          LastChar: firstChar + charWidths.length - 1,
          Widths: charWidths,
          Encoding: 'MacRomanEncoding'
        }
      };
    };

    toUnicodeCmap = function(map) {
      var code, codes, j, len, range, unicode, unicodeMap;
      unicodeMap = '/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo <<\n  /Registry (Adobe)\n  /Ordering (UCS)\n  /Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<00><ff>\nendcodespacerange';
      codes = Object.keys(map).sort(function(a, b) {
        return a - b;
      });
      range = [];
      for (j = 0, len = codes.length; j < len; j++) {
        code = codes[j];
        if (range.length >= 100) {
          unicodeMap += "\n" + range.length + " beginbfchar\n" + (range.join('\n')) + "\nendbfchar";
          range = [];
        }
        unicode = ('0000' + map[code].toString(16)).slice(-4);
        code = (+code).toString(16);
        range.push("<" + code + "><" + unicode + ">");
      }
      if (range.length) {
        unicodeMap += "\n" + range.length + " beginbfchar\n" + (range.join('\n')) + "\nendbfchar\n";
      }
      return unicodeMap += 'endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend';
    };

    PDFFont.prototype.registerAFM = function(name) {
      var ref;
      this.name = name;
      return ref = this.font, this.ascender = ref.ascender, this.decender = ref.decender, this.bbox = ref.bbox, this.lineGap = ref.lineGap, ref;
    };

    PDFFont.prototype.embedAFM = function() {
      this.dictionary.data = {
        Type: 'Font',
        BaseFont: this.name,
        Subtype: 'Type1',
        Encoding: 'WinAnsiEncoding'
      };
      return this.dictionary.end();
    };

    PDFFont.prototype.widthOfString = function(str, size) {
      var charCode, i, j, ref, scale, width;
      str = '' + str;
      width = 0;
      for (i = j = 0, ref = str.length; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
        charCode = str.charCodeAt(i);
        width += this.font.widthOfGlyph(this.font.characterToGlyph(charCode)) || 0;
      }
      scale = size / 1000;
      return width * scale;
    };

    PDFFont.prototype.lineHeight = function(size, includeGap) {
      var gap;
      if (includeGap == null) {
        includeGap = false;
      }
      gap = includeGap ? this.lineGap : 0;
      return (this.ascender + gap - this.decender) / 1000 * size;
    };

    return PDFFont;

  })();

  module.exports = PDFFont;

}).call(this);
