﻿newERP.controller('ConsultaProdutoController', ['$scope', 'ModalService', '$localStorage', '$timeout', 'DadosFormularioService', '$uibModalStack', function ($scope, ModalService, $localStorage, $timeout, DadosFormularioService, $uibModalStack) {

    $scope.conectadoInternet = aplicacaoService.verificarConexao();

    $scope.abrirModalConsultaProduto = function () {
        $scope.modalConsultaProduto = ModalService.model($scope, 'views/pdv/varejo/modalConsultaProduto.html', 'lg', true, 'static', true);
    };

    $scope.fecharModal = function () {
        $uibModalStack.dismissAll();
    }

    $scope.realizandoConsulta = false;
    $scope.mostrarGrades = false;
    $scope.qtdeEstoque = 0;
    $scope.qtdeCondicional = 0;
    $scope.qtdePedido = 0;

    $scope.dadosProduto = {
        pro_id: null,
        pro_codigo: null,
        pro_descricao: null,
        valor: 0,
        pre_qtde: 0
    };

    $scope.limpaCampos = function () {
        $scope.dadosProduto.produto = null;
        $scope.dadosProduto.pro_descricao = null;
        $scope.dadosProduto.pro_codigo = null;
        $scope.dadosProduto.buscaCodigo = null;
        $scope.listaPrecoProdutoEan = null;
        $scope.dadosProduto.pro_id = null;
    };

    $scope.exibicaoProduto = 'fa-barcode';
    $scope.modoExibirPesquisaProduto = function (exibicaoProduto) {
        $scope.limpaCampos();
        if (!!exibicaoProduto) {
            $scope.exibicaoProduto = (exibicaoProduto == 'fa-barcode') ? 'fa-search' : 'fa-barcode';
            $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
        } else {
            if (!!$localStorage.exibicaoProduto) {
                $scope.exibicaoProduto = $localStorage.exibicaoProduto[0].modoExibir;
            } else {
                $scope.exibicaoProduto = 'fa-barcode';
                $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
            }
        }
        if ($scope.exibicaoProduto == 'fa-barcode') {
            $scope.setarFocus('pro_descricao');
        } else {
            $scope.setarFocus('pro_codigo');
        }
    };
    //$scope.modoExibirPesquisaProduto();

    $scope.buscarGradesProduto = function (codigoProduto) {
        $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(codigoProduto));
        $scope.listarGradeProduto = [];
        for (var i = 0; i < $scope.listaGrades.length; i++) {
            atri = {};
            atri.prg_id = $scope.listaGrades[i].prg_id;
            atri.mgp_id = $scope.listaGrades[i].atributos[0].mgp_id;
            atri.mgp_descricao = $scope.listaGrades[i].atributos[0].mgp_descricao;
            $scope.listarGradeProduto.push(atri);
        }
    };

    $scope.lerDadosProduto = function () {
        $timeout(function () {
            var dados = DadosFormularioService.retornaDados('consulta-produto', {}).dados;
        }, 0);
    };

    $scope.buscaDadosProduto = function (produto) {
        var conectadoInternet = aplicacaoService.verificarConexao();
        $scope.listaPrecoProdutoEan = [];
        if (!!produto) {
            if (conectadoInternet) {
                $scope.realizandoConsulta = true;
                $timeout(function () {
                    if ($scope.exibicaoProduto != "fa-barcode") {
                        var resultado = JSON.parse(estoqueAppService.consultarEstoqueGradesPDV(0, produto));
                        $scope.dadosProduto.pro_codigo = resultado[1].pro_codigo;
                        $scope.dadosProduto.pro_descricao = resultado[1].pro_descricao;
                        for (var i = 0; i < resultado.length; i++) {
                            $scope.listaPrecoProdutoEan.push(resultado[i]);
                        };
                    } else { /* BUSCA PELO COMBO */
                        var resultado = JSON.parse(estoqueAppService.consultarEstoqueGradesPDV(produto.pro_id, null));
                        for (var i = 0; i < resultado.length; i++) {
                            $scope.listaPrecoProdutoEan.push(resultado[i]);
                        };
                    };
                    console.log('Dados Produto: ', $scope.listaPrecoProdutoEan);

                    $scope.realizandoConsulta = false;
                }, 150);
            }
            else {
                swal('Você precisa estar conectado a internet para realizar a consulta de estoque. Verifique sua conexão e tente novamente!', 'A conexão com a internet é obrigatória para realizar a consulta de estoque pois assim é possível garantir uma posição de estoque mais coerente, levando em consideração as vendas de todos os PDVs e realizando a consulta de estoque em todas as filiais.', 'warning');
            }
        }
    };

    buscaDadosProdutoAPINewErp = function (dadosProduto, codigoEan) {        
        var res = null;
        $scope.mostraAbaGrade = false;
        if (dadosProduto !== 0) {
            //res = verificaGradeProduto(dadosProduto.pro_id, null);
            //if (res == true) {
                $scope.produtosGrades = buscaDadosProdutoGradesAPINewErp(dadosProduto.pro_id);
                //if ($scope.produtosGrades.length == 1) {
                //    $scope.descricao = $scope.produtosGrades[0].ean;
                //    for (var i = 0; i < $scope.produtosGrades[0].atributos.length; i++) {
                //        $scope.descricao += ' ' + $scope.produtosGrades[0].atributos[i].mgp_descricao;
                //    };
                //}
            //}
                var resultado = JSON.parse(estoqueAppService.consultarEstoqueApi(dadosProduto.pro_id, null));
            
            return resultado;
        } else {
            //res = verificaGradeProduto(null, codigoEan);
            //if (res == true) {
                $scope.produtosGrades = buscaDadosProdutoGradesAPINewErp(null, null, codigoEan);
                //if ($scope.produtosGrades.length == 1) {
                //    $scope.descricao = $scope.produtosGrades[0].ean;
                //    for (var i = 0; i < $scope.produtosGrades[0].atributos.length; i++) {
                //        $scope.descricao += ' ' + $scope.produtosGrades[0].atributos[i].mgp_descricao;
                //    };
                //}
            //}
                var resultado = JSON.parse(estoqueAppService.consultarEstoqueApi(0, codigoEan));
            return resultado;
        }
    };

    buscaDadosProdutoGradesAPINewErp = function (codigoProduto, codigoProdutoGrade, codigoEan) {
        var resultado = JSON.parse(estoqueAppService.consultarEstoqueGradesApi(codigoProduto, codigoProdutoGrade, codigoEan));
        return resultado;
    };

    verificaGradeProduto = function (codigoProduto, codigoEan) {
        var resultado = estoqueAppService.verificaGradeProdutoApi(null, codigoEan);
        return resultado;
    }

}]);