﻿newERP.controller('ChequeController', ['$scope', 'ModalService', '$state', 'ValidarFormularioService', '$timeout', 'DadosFormularioService', 'FuncaoService', '$rootScope', 'hotkeys', function ($scope, ModalService, $state, ValidarFormularioService, $timeout, DadosFormularioService, FuncaoService, $rootScope, hotkeys) {

    $scope.dadosCheque = {};
    $scope.listaClientes = JSON.parse(clienteAppService.listarClientes());

    $scope.lerDados = function () {
        $scope.dadosCheque = DadosFormularioService.retornaDados('dadosCheque', { datavencimento: new Date() }).dados;
        if (!!$scope.dadosCheque.chq_valor) {
            $scope.dadosCheque.linha1 = FuncaoService.retornaValorPorExtenso($scope.dadosCheque.chq_valor);
        }
        var dadosEmpresa = empresaAppService.retornaDadosEmpresa();
        $scope.dadosCheque.linha3 = dadosEmpresa.emp_razaosocial;
    };

    $scope.completarValorPorExtenso = function (valor) {
        $scope.dadosCheque.linha1 = FuncaoService.retornaValorPorExtenso($scope.dadosCheque.chq_valor);
    };

    $scope.listaValidacaoFormulario = [
        { nome: 'cliente', obrigatorio: 'Cliente Obrigatório', invalido: ''},
        { nome: 'codigocompensacao', obrigatorio: 'Comp Obrigatório', invalido: '' },
        { nome: 'banco', obrigatorio: 'Código do Banco Obrigatório', invalido: '' },
        { nome: 'agencia', obrigatorio: 'Número da Agência Obrigatória', invalido: '' },
        { nome: 'c1', obrigatorio: 'C1 Obrigatório', invalido: '' },
        { nome: 'contacorrente', obrigatorio: 'Número da Conta Obrigatória', invalido: '' },
        { nome: 'c2', obrigatorio: 'C2 Obrigatório', invalido: '' },
        { nome: 'numero', obrigatorio: 'Número do cheque Obrigatório', invalido: '' },
        { nome: 'c3', obrigatorio: 'C3 Obrigatório', invalido: '' },
        { nome: 'valor', obrigatorio: 'Valor Obrigatório', invalido: '' },
        { nome: 'datavencimento', obrigatorio: ' Data do Vencimento Obrigatória', invalido: '' },
        { nome: 'serie', obrigatorio: ' Série Obrigatória', invalido: '' }
    ];

    $scope.validarFormulario = function (formulario, dadosCheque) {
        $scope.listaFormularioInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
            $scope.listaFormularioInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;

            if ($scope.listaFormularioInvalido.length === 0) {
                $scope.salvarCheque(dadosCheque);
            }
        });
    };

    $scope.salvarCheque = function (dadosCheque) {
        if (chequeAppService.verificaBanco(dadosCheque.chq_banco)) {
            var retorno = JSON.parse(chequeAppService.verificarCheque(dadosCheque.chq_banco, dadosCheque.chq_agencia, dadosCheque.chq_numero, dadosCheque.chq_contacorrente));
            if (retorno) {
                dadosCheque.usu_id = null;
                dadosCheque.pes_id = dadosCheque.cliente.Id;
                delete dadosCheque.cliente;
                chequeAppService.incluir(JSON.stringify(dadosCheque));
                swal({
                    title: 'Cheque Adicionado com Sucesso!',
                    text: "",
                    type: "success",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "OK",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            $rootScope.$broadcast('ChequeCadastrado!');
                            $scope.closeModalCheque();
                        }, 100);
                    }
                });
            } else {
                swal({
                    title: 'Cheque já cadastrado no Sistema!',
                    text: "",
                    type: "warning",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "OK",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        return;
                    };
                });
            };
        }
        else {
            swal("O Banco informado é INVÁLIDO!", "", "warning");
        }
    };

    hotkeys.bindTo($scope)
    .add({
      combo: 'return',
      description: 'Salvar',
      allowIn: ['INPUT'],
      callback: function () {
        $scope.validarFormulario($scope.formularioCheque, $scope.dadosCheque);
      }
    });

    $scope.setarFocus = function (nomeElemento) {
        if (!!nomeElemento) $timeout(function () {
            document.getElementsByName(nomeElemento)[0].focus();
        });
    };

    $scope.closeModalCheque = function () {
        DadosFormularioService.limparDados('dadosCheque');
        $scope.modalCheque.close();
    };
}]);
